from django.urls import path
# Import views using the lazy loading mechanism
from .views import (
    UserListView, UserDetailView, UserCreateView, UserUpdateView, UserDeleteView,
    RoleListView, RoleDetailView, RoleCreateView, RoleUpdateView, RoleDeleteView
)

# Main app namespace
app_name = 'users'

# URL patterns for users app
urlpatterns = [
    # User management
    path('', UserListView.as_view(), name='user_list'),
    path('create/', UserCreateView.as_view(), name='user_create'),
    path('<int:pk>/', UserDetailView.as_view(), name='user_detail'),
    path('<int:pk>/update/', UserUpdateView.as_view(), name='user_update'),
    path('<int:pk>/delete/', UserDeleteView.as_view(), name='user_delete'),
    
    # Role management
    path('roles/', RoleListView.as_view(), name='role_list'),
    path('roles/create/', RoleCreateView.as_view(), name='role_create'),
    path('roles/<int:pk>/', RoleDetailView.as_view(), name='role_detail'),
    path('roles/<int:pk>/update/', RoleUpdateView.as_view(), name='role_update'),
    path('roles/<int:pk>/delete/', RoleDeleteView.as_view(), name='role_delete'),
]
